<?php
header ('Content-type: text/html; charset=utf-8');
session_start();
ob_start();




/*
 * Database Setup
 */
 require_once 'ezSQL/shared/ez_sql_core.php';
 require_once 'ezSQL/ez_sql_mysql.php';

 $db = new ezSQL_mysql('DB_USER', 'DB_PASS', 'DB_NAME', 'localhost');
 $db->query("set character_set_client='utf8'"); 
 $db->query("set character_set_results='utf8'"); 
 $db->query("set collation_connection='utf8_general_ci'"); 

/*
 * Payments setup
 */
$site_settings = $db->get_row("SELECT paypal, percent, min_order FROM settings LIMIT 1"); 
define("PAYPAL_EMAIL", $site_settings->paypal);

/*
 * Site URL & Settings
 */
define('SITE', 'http://localhost:8888');
define('USER_PERCENT_PER_K', $site_settings->percent);
define('ADMIN_USER', 'admin');
define('ADMIN_PASS', md5('admin_pass'));
define('MIN_ORDER', $site_settings->min_order);
define("AFFILIATE_PERCENTAGE", 25);

/*
 * Load language files
 * Add your translated files here
 */
 require_once 'language/lang.your_language.php';
 require_once 'language/lang.en.php';
 require_once 'language/lang.ro.php';

/*
 * Default Language
 */
 define('DEFAULT_LANGUAGE', 'en');
 
 if(isset($_SESSION['language'])) {
 	define('LANG', $_SESSION['language']);
 }elseif(!isset($_SESSION['language'])) {
 	define('LANG', DEFAULT_LANGUAGE);
 }
 
 if(isset($_GET['language']) AND !empty($_GET['language'])){
 	$the_lang = $db->escape(trim(strip_tags($_GET['language'])));
	
	if(file_exists(getcwd().'/language/lang.'.$the_lang.'.php')) {
		$_SESSION['language'] = $the_lang;
		header("Location: /");
		exit;
	}else{
		print '<div class="alert alert-error">Language file does not exist</div>';
	}
	
 }
 
 function translate($string) {
 	global $lang;
 	if(isset($lang[LANG][$string])) {
		return $lang[LANG][$string];
	}else{
		return $string . ' not translated into ' . LANG;
	}
 }
 
 /*
  * Register Affiliate with Cookie
  */
  if(isset($_GET['id'])) {
  	  $id = (int) $db->escape(abs(intval($_GET['id'])));
	  if($id > 0) {
	  	  setcookie('affID', $id, time()+3600*24, '/');
		  header("Location: ".SITE."".$_SERVER['PHP_SELF']);
	  }
  }
  

/*
 * Classes Include
*/
require_once 'classes/Users.php';
$usersObject = new Users();

require_once 'classes/Categories.php';
$categoriesObject = new Categories();

/*
 * Disable magic quotes
*/
if (get_magic_quotes_gpc()) {
	$process = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
	while (list($key, $val) = each($process)) {
		foreach ($val as $k => $v) {
			unset($process[$key][$k]);
			if (is_array($v)) {
				$process[$key][stripslashes($k)] = $v;
				$process[] = &$process[$key][stripslashes($k)];
			} else {
				$process[$key][stripslashes($k)] = stripslashes($v);
			}
		}
	}
	unset($process);
}

/*
 * Get IP Address
 */
function getRealIpAddr()
{
    if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
    {
      $ip=$_SERVER['HTTP_CLIENT_IP'];
    }
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
    {
      $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    else
    {
      $ip=$_SERVER['REMOTE_ADDR'];
    }
    return $ip;
} 

define('WAIT_SECONDS', 5);

?>